package ml.pluto7073.teatime.recipe;

import ml.pluto7073.teatime.TeaTime;
import ml.pluto7073.teatime.recipe.special.SpecialAdditionSerializer;
import ml.pluto7073.teatime.recipe.special.TTSpecialRecipeSerializer;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class ModRecipes {

    //Recipe Types
    public static final class_3956<SteamerRecipe> STEAMING;
    public static final class_3956<RollingRecipe> ROLLING;
    //Serializers
    public static final class_1865<SteamerRecipe> STEAMING_SERIALIZER;
    public static final class_1865<RollingRecipe> ROLLING_SERIALIZER;
    public static final class_1866<TeaBagRecipe> TEA_BAG_MAKING;
    public static final class_1866<TeaRecipe> TEA_BREWING;
    public static final TTSpecialRecipeSerializer<DriedTeaLeaves> DRIED_TEA_LEAVES;
    public static final TTSpecialRecipeSerializer<DriedTeaLeavesBlasting> DRIED_TEA_LEAVES_BLASTING;
    public static final SpecialAdditionSerializer<TeaInLatteAdditionRecipe> TEA_IN_LATTE;

    private static <T extends class_1860<?>> class_3956<T> register(final String id) {
        return class_2378.method_10230(class_7923.field_41188, new class_2960(TeaTime.MOD_ID, id), new class_3956<T>() {
            @Override
            public String toString() {
                return new class_2960(TeaTime.MOD_ID, id).toString();
            }
        });
    }

    private static <S extends class_1865<T>, T extends class_1860<?>> S register(String id, S serializer) {
        return class_2378.method_10230(class_7923.field_41189, new class_2960(TeaTime.MOD_ID, id), serializer);
    }

    static {
        //Recipe Types
        STEAMING = register("steaming");
        ROLLING = register("rolling");
        //Serializers
        STEAMING_SERIALIZER = register("steaming", new SteamerRecipe.Serializer(1200));
        ROLLING_SERIALIZER = register("rolling", new RollingRecipe.Serializer(1.0));
        TEA_BAG_MAKING = register("crafting_special_teabagmaking", new class_1866<>(TeaBagRecipe::new));
        TEA_BREWING = register("crafting_special_teabrewing", new class_1866<>(TeaRecipe::new));
        DRIED_TEA_LEAVES = register("smelting_special_driedtealeaves", new TTSpecialRecipeSerializer<>(DriedTeaLeaves::new));
        DRIED_TEA_LEAVES_BLASTING = register("blasting_special_driedtealeaves", new TTSpecialRecipeSerializer<>(DriedTeaLeavesBlasting::new));
        TEA_IN_LATTE = register("drink_workstation_special_teainlatte", new SpecialAdditionSerializer<>(TeaInLatteAdditionRecipe::new));
    }

    public static void init() {}

}
