package ml.pluto7073.teatime.teatypes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ml.pluto7073.pdapi.PDRegistries;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkBase;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkBaseSerializer;
import ml.pluto7073.teatime.TeaTime;
import ml.pluto7073.teatime.item.ModItems;
import ml.pluto7073.teatime.utils.TeaTimeUtils;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_5321;

public class TeaSpecialtyBase implements SpecialtyDrinkBase {

    public static final TeaBaseSerializer INSTANCE = new TeaBaseSerializer();

    private final class_5321<TeaType> teaType;

    public TeaSpecialtyBase(class_5321<TeaType> teaType) {
        this.teaType = teaType;
    }

    @Override
    public class_1799 buildItemStack() {
        return TeaTimeUtils.setTeaType(new class_1799(ModItems.TEA), teaType);
    }

    @Override
    public boolean matches(class_1799 stack) {
        return TeaTimeUtils.getTeaTypeId(stack).equals(teaType.method_29177());
    }

    @Override
    public SpecialtyDrinkBaseSerializer serializer() {
        return INSTANCE;
    }

    public static void init() {
        class_2378.method_10230(PDRegistries.SPECIALTY_DRINK_BASE, TeaTime.asId("tea"), INSTANCE);
    }

    public static class TeaBaseSerializer implements SpecialtyDrinkBaseSerializer {

        public static final Codec<TeaSpecialtyBase> CODEC = RecordCodecBuilder.create(instance ->
                instance.group(class_5321.method_39154(TeaTypeManager.TEA_TYPE).fieldOf("tea")
                        .forGetter(base -> base.teaType))
                        .apply(instance, TeaSpecialtyBase::new));

        @Override
        public Codec<? extends SpecialtyDrinkBase> codec() {
            return CODEC;
        }

        @Override
        public void toNetwork(class_2540 buf, SpecialtyDrinkBase base) {
            if (!(base instanceof TeaSpecialtyBase tea)) return;
            buf.method_44116(tea.teaType);
        }

        @Override
        public SpecialtyDrinkBase fromNetwork(class_2540 buf) {
            class_5321<TeaType> tea = buf.method_44112(TeaTypeManager.TEA_TYPE);
            return new TeaSpecialtyBase(tea);
        }
    }

}
