package ml.pluto7073.teatime.teatypes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import ml.pluto7073.teatime.utils.TeaTimeUtils;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.commons.compress.utils.Lists;

import java.util.*;

public class TeaType {

    public static final Codec<TeaType> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(Codec.optionalField("parent", class_5321.method_39154(TeaTypeManager.TEA_TYPE))
                            .forGetter(type -> type.parent),
                            Codec.INT.fieldOf("color").orElse(0).forGetter(TeaType::getColour),
                            Codec.list(class_7923.field_41178.method_39673()).fieldOf("ingredients")
                                    .forGetter(type -> type.ingredients),
                            Codec.INT.fieldOf("caffeine").orElse(0)
                                    .forGetter(type -> type.caffeine),
                            Codec.list(TeaTimeUtils.MOB_EFFECT_CODEC).fieldOf("effects")
                                    .forGetter(type -> type.effects),
                            Codec.BOOL.fieldOf("internal").orElse(false)
                                    .forGetter(TeaType::internal),
                            Codec.STRING.fieldOf("name").orElse("")
                                    .forGetter(type -> type.name))
                    .apply(instance, TeaType::new));

    private final Optional<class_5321<TeaType>> parent;
    private final List<class_1792> ingredients;
    private final int colour;
    private final int caffeine;
    private final List<class_1293> effects;
    private final boolean internal;
    private final String name;

    public TeaType(Optional<class_5321<TeaType>> parent, int colour, List<class_1792> ingredients, int caffeine, List<class_1293> effects, boolean internal, String name) {
        if (parent.isPresent() && internal)
            throw new IllegalStateException("Internal TeaType's can't have parents");
        this.parent = parent;
        this.colour = colour;
        this.ingredients = ingredients;
        this.effects = effects;
        this.caffeine = caffeine;
        this.internal = internal;
        this.name = name;
    }

    public Optional<class_5321<TeaType>> parent() {
        return parent;
    }

    public boolean internal() {
        return internal;
    }

    public List<class_1792> getIngredients() {
        ArrayList<class_1792> list = Lists.newArrayList(this.ingredients.iterator());
        parent.ifPresent(type ->
                list.addAll(TeaTypeManager.get(type).getIngredients()));
        return list;
    }

    public int getColour() {
        return parent.isPresent() && colour == 0 ? TeaTypeManager.get(parent.get()).colour : colour;
    }

    public String getTranslationKey() {
        if (name != null && !name.isEmpty()) return name;
        class_2960 id = TeaTypeManager.getId(this);
        return id.method_42093("tea_type");
    }

    public int getCaffeine() {
        return parent.map(teaTypeResourceKey -> TeaTypeManager.get(teaTypeResourceKey).caffeine)
                .orElse(caffeine);
    }

    public List<class_1293> getEffects() {
        ArrayList<class_1293> list = Lists.newArrayList(this.effects.iterator());
        parent.ifPresent(teaTypeResourceKey ->
                list.addAll(TeaTypeManager.get(teaTypeResourceKey).getEffects()));
        return list;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_37435(parent, class_2540::method_44116);
        buf.writeInt(colour);
        NetworkingUtils.arrayToNetwork(buf, ingredients.stream()
                .map(class_7923.field_41178::method_10221).toArray(class_2960[]::new),
                class_2540::method_10812);
        buf.writeInt(caffeine);
        NetworkingUtils.arrayToNetwork(buf, effects.toArray(class_1293[]::new), (b, instance) -> {
            b.method_10812(class_7923.field_41174.method_10221(instance.method_5579()));
            b.writeInt(instance.method_5584());
            b.writeInt(instance.method_5578());
        });
        buf.writeBoolean(internal);
        buf.method_10814(name == null ? "" : name);
    }

    public static TeaType fromNetwork(class_2540 buf) {
        Optional<class_5321<TeaType>> parent =
                buf.method_37436(b -> b.method_44112(TeaTypeManager.TEA_TYPE));
        int color = buf.readInt();
        List<class_1792> ingredients = NetworkingUtils.listFromNetwork(buf, class_2540::method_10810)
                .stream().map(class_7923.field_41178::method_10223).toList();
        int caffeine = buf.readInt();
        List<class_1293> effects = NetworkingUtils.listFromNetwork(buf, b -> {
            class_1291 effect = class_7923.field_41174.method_17966(b.method_10810())
                    .orElseThrow();
            int duration = b.readInt();
            int amplifier = b.readInt();
            return new class_1293(effect, duration, amplifier);
        });
        boolean internal = buf.readBoolean();
        String name = buf.method_19772();
        return new TeaType(parent, color, ingredients, caffeine, effects, internal, name);
    }

}
