/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.teatime.teatypes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ml.pluto7073.pdapi.networking.NetworkingUtils;
import ml.pluto7073.teatime.teatypes.TeaTypeManager;
import ml.pluto7073.teatime.utils.TeaTimeUtils;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.apache.commons.compress.utils.Lists;

public class TeaType {
    public static final Codec<TeaType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.optionalField((String)"parent", (Codec)class_5321.method_39154(TeaTypeManager.TEA_TYPE)).forGetter(type -> type.parent), (App)Codec.INT.fieldOf("color").orElse((Object)0).forGetter(TeaType::getColour), (App)Codec.list((Codec)class_7923.field_41178.method_39673()).fieldOf("ingredients").forGetter(type -> type.ingredients), (App)Codec.INT.fieldOf("caffeine").orElse((Object)0).forGetter(type -> type.caffeine), (App)Codec.list(TeaTimeUtils.MOB_EFFECT_CODEC).fieldOf("effects").forGetter(type -> type.effects), (App)Codec.BOOL.fieldOf("internal").orElse((Object)false).forGetter(TeaType::internal), (App)Codec.STRING.fieldOf("name").orElse((Object)"").forGetter(type -> type.name)).apply((Applicative)instance, TeaType::new));
    private final Optional<class_5321<TeaType>> parent;
    private final List<class_1792> ingredients;
    private final int colour;
    private final int caffeine;
    private final List<class_1293> effects;
    private final boolean internal;
    private final String name;

    public TeaType(Optional<class_5321<TeaType>> parent, int colour, List<class_1792> ingredients, int caffeine, List<class_1293> effects, boolean internal, String name) {
        if (parent.isPresent() && internal) {
            throw new IllegalStateException("Internal TeaType's can't have parents");
        }
        this.parent = parent;
        this.colour = colour;
        this.ingredients = ingredients;
        this.effects = effects;
        this.caffeine = caffeine;
        this.internal = internal;
        this.name = name;
    }

    public Optional<class_5321<TeaType>> parent() {
        return this.parent;
    }

    public boolean internal() {
        return this.internal;
    }

    public List<class_1792> getIngredients() {
        ArrayList list = Lists.newArrayList(this.ingredients.iterator());
        this.parent.ifPresent(type -> list.addAll(TeaTypeManager.get((class_5321<TeaType>)type).getIngredients()));
        return list;
    }

    public int getColour() {
        return this.parent.isPresent() && this.colour == 0 ? TeaTypeManager.get(this.parent.get()).colour : this.colour;
    }

    public String getTranslationKey() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        class_2960 id = TeaTypeManager.getId(this);
        return id.method_42093("tea_type");
    }

    public int getCaffeine() {
        return this.parent.map(teaTypeResourceKey -> TeaTypeManager.get((class_5321<TeaType>)teaTypeResourceKey).caffeine).orElse(this.caffeine);
    }

    public List<class_1293> getEffects() {
        ArrayList list = Lists.newArrayList(this.effects.iterator());
        this.parent.ifPresent(teaTypeResourceKey -> list.addAll(TeaTypeManager.get((class_5321<TeaType>)teaTypeResourceKey).getEffects()));
        return list;
    }

    public void toNetwork(class_2540 buf) {
        buf.method_37435(this.parent, class_2540::method_44116);
        buf.writeInt(this.colour);
        NetworkingUtils.arrayToNetwork((class_2540)buf, (Object[])((class_2960[])this.ingredients.stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).toArray(class_2960[]::new)), class_2540::method_10812);
        buf.writeInt(this.caffeine);
        NetworkingUtils.arrayToNetwork((class_2540)buf, (Object[])((class_1293[])this.effects.toArray(class_1293[]::new)), (b, instance) -> {
            b.method_10812(class_7923.field_41174.method_10221((Object)instance.method_5579()));
            b.writeInt(instance.method_5584());
            b.writeInt(instance.method_5578());
        });
        buf.writeBoolean(this.internal);
        buf.method_10814(this.name == null ? "" : this.name);
    }

    public static TeaType fromNetwork(class_2540 buf) {
        Optional parent = buf.method_37436(b -> b.method_44112(TeaTypeManager.TEA_TYPE));
        int color = buf.readInt();
        List<class_1792> ingredients = NetworkingUtils.listFromNetwork((class_2540)buf, class_2540::method_10810).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).toList();
        int caffeine = buf.readInt();
        List effects = NetworkingUtils.listFromNetwork((class_2540)buf, b -> {
            class_1291 effect = (class_1291)class_7923.field_41174.method_17966(b.method_10810()).orElseThrow();
            int duration = b.readInt();
            int amplifier = b.readInt();
            return new class_1293(effect, duration, amplifier);
        });
        boolean internal = buf.readBoolean();
        String name = buf.method_19772();
        return new TeaType(parent, color, ingredients, caffeine, effects, internal, name);
    }
}

