package ml.pluto7073.teatime;

import ml.pluto7073.pdapi.addition.DrinkAdditionManager;
import ml.pluto7073.pdapi.item.PDItems;
import ml.pluto7073.pdapi.specialty.SpecialtyDrinkManager;
import ml.pluto7073.teatime.action.TeaTimeActions;
import ml.pluto7073.teatime.block.ModBlocks;
import ml.pluto7073.teatime.block.entity.ModBlockEntityTypes;
import ml.pluto7073.teatime.entity.TTTrackedData;
import ml.pluto7073.teatime.event.ModEvents;
import ml.pluto7073.teatime.gui.handlers.TTMenuTypes;
import ml.pluto7073.teatime.item.ModItems;
import ml.pluto7073.teatime.recipe.ModRecipes;
import ml.pluto7073.teatime.stats.TTStats;
import ml.pluto7073.teatime.teatypes.TeaSpecialtyBase;
import ml.pluto7073.teatime.teatypes.TeaTypeManager;
import ml.pluto7073.teatime.utils.TeaTimeUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeaTime implements ModInitializer {

    public static final String MOD_ID = "teatime";
    public static final Logger logger = LogManager.getLogger("TeaTime");
    public static class_5321<class_1761> TT_GROUP;

    @Override
    public void onInitialize() {
        TeaSpecialtyBase.init();
        ModBlocks.init();
        ModBlockEntityTypes.init();
        ModRecipes.init();
        ModItems.init();
        TeaTypeManager.init();
        TTStats.init();
        TTTrackedData.init();
        TeaTimeActions.init();
        createItemGroup();
        registerResourceReloadListener();
        ModEvents.init();
        TTMenuTypes.init();
    }

    public static void createItemGroup() {
        TT_GROUP = class_5321.method_29179(class_7924.field_44688, asId("tt_group"));
        class_2378.method_39197(class_7923.field_44687, TT_GROUP, FabricItemGroup.builder()
                .method_47320(() -> new class_1799(ModItems.TEA_LEAVES)).method_47321(class_2561.method_43471("itemGroup.teatime.tt_group")).method_47324());
        ItemGroupEvents.modifyEntriesEvent(TT_GROUP).register(stacks -> {
                    stacks.method_45420(new class_1799(ModItems.STEAMER));
                    stacks.method_45421(PDItems.DRINK_WORKSTATION);
                    stacks.method_45420(new class_1799(ModItems.TEA_SEEDS));
                    stacks.method_45420(new class_1799(ModItems.TEA_LEAVES));
                    stacks.method_45420(new class_1799(ModItems.WITHERED_TEA_LEAVES));
                    stacks.method_45420(new class_1799(ModItems.WHITE_TEA_LEAVES));
                    stacks.method_45420(new class_1799(ModItems.STEAMED_TEA_LEAVES));
                    stacks.method_45423(TeaTimeUtils.getRolledLeaves());
                    stacks.method_45420(new class_1799(ModItems.DRIED_TEA_LEAVES));
                    stacks.method_45420(new class_1799(ModItems.FERMENTED_TEA_LEAVES));
                    stacks.method_45423(TeaTimeUtils.getTeaBags());
                    stacks.method_45423(TeaTimeUtils.getTea());
                    stacks.method_45421(PDItems.MILK_BOTTLE);
                });
    }

    public static void registerResourceReloadListener() {
        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new TeaTypeManager());
    }

    public static class_2960 asId(String name) {
        return new class_2960(MOD_ID, name);
    }

}
