package ml.pluto7073.teatime.mixin;

import ml.pluto7073.teatime.entity.TTTrackedData;
import net.minecraft.class_1533;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1533.class)
public abstract class ItemFrameMixin extends HangingEntityMixin {

    @Inject(at = @At("TAIL"), method = "defineSynchedData")
    public void teatime$initWitheringData(CallbackInfo ci) {
        this.entityData.method_12784(TTTrackedData.WITHERING_AGE, 0);
        this.entityData.method_12784(TTTrackedData.WITHERING, false);
    }

    @Inject(at = @At("TAIL"), method = "addAdditionalSaveData")
    public void teatime$saveWitheringData(class_2487 nbt, CallbackInfo ci) {
        class_2487 compound = new class_2487();
        compound.method_10569("WitheringAge", this.entityData.method_12789(TTTrackedData.WITHERING_AGE));
        compound.method_10556("Withering", this.entityData.method_12789(TTTrackedData.WITHERING));
        nbt.method_10566("WitheringData", compound);
    }

    @Inject(at = @At("TAIL"), method = "readAdditionalSaveData")
    public void teatime$getWitheringData(class_2487 nbt, CallbackInfo ci) {
        if (!nbt.method_10545("WitheringData")) return;

        class_2487 witheringData = nbt.method_10562("WitheringData");

        if (witheringData.method_10545("WitheringAge")) {
            this.entityData.method_12778(TTTrackedData.WITHERING_AGE, witheringData.method_10550("WitheringAge"));
        }

        if (witheringData.method_10545("Withering")) {
            this.entityData.method_12778(TTTrackedData.WITHERING, witheringData.method_10577("Withering"));
        }
    }

}
