package ml.pluto7073.teatime.recipe;

import ml.pluto7073.teatime.item.ModItems;
import ml.pluto7073.teatime.teatypes.TeaType;
import ml.pluto7073.teatime.utils.TeaTimeUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6328;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

@class_6328
public class TeaRecipe extends class_1852 {

    public TeaRecipe(class_2960 id, class_7710 category) {
        super(id, category);
    }

    @Override
    public boolean matches(class_8566 container, class_1937 world) {
        boolean hasWaterBottle = false;
        boolean hasTeaBag = false;

        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_31574(class_1802.field_8574) && !hasWaterBottle) {
                if (class_1844.method_8063(stack).equals(class_1847.field_8991)) {
                    hasWaterBottle = true;
                } else {
                    return false;
                }
            } else {
                if (!stack.method_31574(ModItems.TEA_BAG) || hasTeaBag) {
                    return false;
                }
                hasTeaBag = true;
            }
        }
        return hasTeaBag && hasWaterBottle;
    }

    @Override
    public class_1799 assemble(class_8566 container, class_5455 manager) {
        class_1799 teaBag = class_1799.field_8037;
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_31574(ModItems.TEA_BAG)) {
                teaBag = stack;
                break;
            }
        }
        TeaType type = TeaTimeUtils.getTeaType(teaBag);
        return TeaTimeUtils.setTeaType(new class_1799(ModItems.TEA, 1), type);
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width >= 1 && height >= 1;
    }

    @Override
    public class_1865<?> method_8119() {
        return ModRecipes.TEA_BREWING;
    }

}
