package ml.pluto7073.teatime.teatypes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.*;
import com.mojang.serialization.JsonOps;
import ml.pluto7073.pdapi.util.DrinkUtil;
import ml.pluto7073.teatime.TeaTime;
import ml.pluto7073.teatime.item.ModItems;
import ml.pluto7073.teatime.networking.packets.clientbound.ClientboundSyncCustomTeaTypesPacket;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;

public class TeaTypeManager implements SimpleSynchronousResourceReloadListener {

    public static final class_2960 PHASE = TeaTime.asId("phase/tea_types");

    public static final class_5321<class_2378<TeaType>> TEA_TYPE =
            class_5321.method_29180(TeaTime.asId("tea_type"));

    public static final class_5321<TeaType> EMPTY = baseType("empty");
    public static final class_5321<TeaType> HERBAL_TEA = baseType("herbal_tea");
    public static final class_5321<TeaType> WHITE_TEA = baseType("white_tea");
    public static final class_5321<TeaType> GREEN_TEA = baseType("green_tea");
    public static final class_5321<TeaType> BLACK_TEA = baseType("black_tea");

    private static final Map<class_2960, TeaType> REGISTRY = new HashMap<>();

    public static final TeaType EMPTY_TYPE = new TeaType(Optional.empty(), 0,
            List.of(), 0, List.of(), true, "");

    public TeaTypeManager() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> TeaTypeManager.send(player));
    }

    private static class_5321<TeaType> baseType(String id) {
        return class_5321.method_29179(TEA_TYPE, TeaTime.asId(id));
    }

    public static TeaType register(class_2960 id, TeaType teaType) {
        REGISTRY.put(id, teaType);
        return teaType;
    }

    public static TeaType getFromIngredients(List<class_1792> stacks) {
        main: for (class_2960 i : REGISTRY.keySet()) {
            if (i.toString().equals("teatime:empty") || i.toString().equals("teatime:herbal_tea")) continue;
            TeaType type = REGISTRY.get(i);
            List<class_1792> wantedItems = new ArrayList<>(type.getIngredients());
            if (stacks.size() != wantedItems.size()) continue;
            for (class_1792 item : stacks) {
                if (!wantedItems.remove(item)) continue main;
            }
            if (wantedItems.isEmpty()) return type;
        }
        return EMPTY_TYPE;
    }

    public static TeaType get(class_5321<TeaType> key) {
        return get(key.method_29177());
    }

    public static TeaType get(class_2960 id) {
        if (!REGISTRY.containsKey(id)) {
            return EMPTY_TYPE;
        }
        return REGISTRY.get(id);
    }

    public static void send(class_3222 player) {

        ServerPlayNetworking.send(player,
                new ClientboundSyncCustomTeaTypesPacket(ImmutableMap.copyOf(REGISTRY)));

    }

    public static boolean containsId(class_2960 id) {
        return REGISTRY.containsKey(id);
    }

    public static class_2960 getId(TeaType teaType) {
        for (class_2960 i : REGISTRY.keySet()) {
            TeaType type = REGISTRY.get(i);
            if (type.equals(teaType)) {
                return i;
            }
        }
        return new class_2960("empty");
    }

    public static Set<class_2960> getIds() {
        return REGISTRY.keySet();
    }

    public static List<class_2960> getOrderedIdListDisplayed() {
        Set<class_2960> allIds = getIds();
        List<class_2960> herbalTeas = new ArrayList<>();
        List<class_2960> whiteTeas = new ArrayList<>();
        List<class_2960> greenTeas = new ArrayList<>();
        List<class_2960> blackTeas = new ArrayList<>();
        List<class_2960> miscTeas = new ArrayList<>();
        for (class_2960 id : allIds) {
            TeaType type = get(id);
            if (type.internal()) continue;
            if (type.parent().isEmpty()) {
                miscTeas.add(id);
                continue;
            }
            if (type.parent().equals(Optional.of(HERBAL_TEA))) herbalTeas.add(id);
            else if (type.parent().equals(Optional.of(WHITE_TEA))) whiteTeas.add(id);
            else if (type.parent().equals(Optional.of(GREEN_TEA))) greenTeas.add(id);
            else if (type.parent().equals(Optional.of(BLACK_TEA))) blackTeas.add(id);
            else miscTeas.add(id);
        }
        Comparator<class_2960> comparator = DrinkUtil.alphabetizer(class_2960::toString);
        herbalTeas.sort(comparator);
        whiteTeas.sort(comparator);
        greenTeas.sort(comparator);
        blackTeas.sort(comparator);
        miscTeas.sort(comparator);
        whiteTeas.add(0, WHITE_TEA.method_29177());
        greenTeas.add(0, GREEN_TEA.method_29177());
        blackTeas.add(0, BLACK_TEA.method_29177());
        return Streams.concat(herbalTeas.stream(), whiteTeas.stream(), greenTeas.stream(), blackTeas.stream())
                .toList();
    }

    public static List<TeaType> values() {
        return REGISTRY.values().stream().toList();
    }

    public static void init() {}

    public static void resetRegistry() {
        REGISTRY.clear();
    }

    @Override
    public class_2960 getFabricId() {
        return TeaTime.asId("tea_type_registerer");
    }

    @Override
    public void method_14491(class_3300 manager) {
        TeaTypeManager.resetRegistry();

        int i = 0;

        for (Map.Entry<class_2960, class_3298> entry : manager.method_14488("tea_types", id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = new class_2960(entry.getKey().method_12836(),
                    entry.getKey().method_12832()
                            .replace("tea_types/", "")
                            .replace(".json", ""));

            try (InputStream stream = entry.getValue().method_14482()) {
                JsonObject object = class_3518.method_15255(new InputStreamReader(stream));

                if (object.has("fabric:load_conditions")) {
                    boolean b = ResourceConditions.conditionsMatch(
                            class_3518.method_15261(object, "fabric:load_conditions"),
                            true
                    );

                    if (!b) continue;
                }

                TeaTypeManager.register(id, TeaType.CODEC.parse(JsonOps.INSTANCE, object).getOrThrow(false, s -> {
                    throw new JsonSyntaxException(s);
                }));
                i++;
            } catch (Exception e) {
                TeaTime.logger.error("Could not load custom tea type {}", id, e);
            }
        }

        TeaTime.logger.info("Loaded {} custom tea types", i);
    }

}
