package ml.pluto7073.teatime.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ml.pluto7073.pdapi.util.DrinkUtil;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.teatime.item.ModItems;
import ml.pluto7073.teatime.teatypes.TeaType;
import ml.pluto7073.teatime.teatypes.TeaTypeManager;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class TeaTimeUtils {

    public static final Map<String, class_1792> DRYING_RESULTS = new HashMap<>();
    public static final int MAX_TIME_DRYING = 200;
    public static final Codec<class_1293> MOB_EFFECT_CODEC = RecordCodecBuilder.create(instance ->
            instance.group(class_7923.field_41174.method_39673().fieldOf("effect")
                                .forGetter(class_1293::method_5579),
                            Codec.INT.fieldOf("duration").forGetter(class_1293::method_5584),
                            Codec.INT.fieldOf("amplifier").forGetter(class_1293::method_5578))
                    .apply(instance, class_1293::new));

    public static List<class_1799> getRolledLeaves() {
        List<class_1799> stacks = new ArrayList<>();
        for (String s : DRYING_RESULTS.keySet()) {
            class_1799 stack = new class_1799(ModItems.ROLLED_TEA_LEAVES);
            stack.method_7911("TeaData").method_10582("mod", s);
            stacks.add(stack);
        }
        return stacks;
    }

    public static List<class_1799> getTeaBags() {
        List<class_1799> stacks = new ArrayList<>();
        class_1799 stack = new class_1799(ModItems.TEA_BAG);
        for (class_2960 i : TeaTypeManager.getOrderedIdListDisplayed()) {
            if (i.equals(new class_2960("teatime:empty"))) continue;
            stacks.add(setTeaType(stack.method_7972(), TeaTypeManager.get(i)));
        }
        return stacks;
    }

    public static List<class_1799> getTea() {
        List<class_1799> stacks = new ArrayList<>();
        class_1799 tea = new class_1799(ModItems.TEA, 1);
        for (class_2960 i : TeaTypeManager.getOrderedIdListDisplayed()) {
            if (i.equals(new class_2960("teatime:empty"))) continue;
            stacks.add(setTeaType(tea.method_7972(), TeaTypeManager.get(i)));
        }
        return stacks;
    }

    public static class_1792 getDryingResult(class_1799 stack) {
        String mod = stack.method_7911("TeaData").method_10545("mod") ?
                stack.method_7911("TeaData").method_10558("mod") : "teatime:null";
        return DRYING_RESULTS.getOrDefault(mod, ModItems.ROLLED_TEA_LEAVES);
    }

    public static boolean hasDryingResult(class_1799 stack) {
        String mod = stack.method_7911("TeaData").method_10545("mod") ?
                stack.method_7911("TeaData").method_10558("mod") : "teatime:null";
        return DRYING_RESULTS.containsKey(mod);
    }

    public static String getRolledTooltip(class_1799 stack) {
        String mod = stack.method_7911("TeaData").method_10558("mod");
        class_1792 result = DRYING_RESULTS.get(mod);
        if (result == null) return "";
        return result.method_7876();
    }

    public static String getTeaTypeStr(class_1799 stack) {
        return stack.method_7911("TeaData").method_10545("type") ? stack.method_7911("TeaData").method_10558("type") : "teatime:empty";
    }

    public static TeaType getTeaType(class_1799 stack) {
        return getTeaType(stack.method_7911("TeaData"));
    }

    public static TeaType getTeaType(class_2487 teaData) {
        String type = teaData.method_10545("type") ? teaData.method_10558("type") : "teatime:empty";
        return TeaTypeManager.containsId(new class_2960(type)) ? TeaTypeManager.get(new class_2960(type)) : TeaTypeManager.EMPTY_TYPE;
    }

    public static class_2960 getTeaTypeId(class_1799 stack) {
        TeaType type = getTeaType(stack);
        return TeaTypeManager.getId(type);
    }

    public static class_1799 setTeaType(class_1799 stack, TeaType type) {
        return setTeaType(stack, TeaTypeManager.getId(type));
    }

    public static class_1799 setTeaType(class_1799 stack, class_2960 teaId) {
        stack.method_7911("TeaData").method_10582("type", teaId.toString());
        return stack;
    }

    public static class_1799 setTeaType(class_1799 stack, class_5321<TeaType> id) {
        return setTeaType(stack, id.method_29177());
    }

    public static <T> T create(Supplier<T> supplier) {
        return supplier.get();
    }

    public static int getTeaColor(class_1799 stack) {
        int colour = 0;
        if (getTeaType(stack) != null) colour = getTeaType(stack).getColour();
        float r = (colour >> 16 & 255) / 255.0F;
        float g = (colour >> 8 & 255) / 255.0F;
        float b = (colour & 255) / 255.0F;
        int colourCount = 1;

        for (DrinkAddition addition : DrinkUtil.getAdditionsFromStack(stack)) {
            if (!addition.changesColor()) continue;
            int additionColour = addition.getColor();
            r += (additionColour >> 16 & 255) / 255.0F;
            g += (additionColour >> 8 & 255) / 255.0F;
            b += (additionColour & 255) / 255.0F;
            colourCount += 1;
        }
        r = r / (float) colourCount * 255.0F;
        g = g / (float) colourCount * 255.0F;
        b = b / (float) colourCount * 255.0F;
        return (int) r << 16 | (int) g << 8 | (int) b;
    }

    static {
        DRYING_RESULTS.put("teatime:steamed", ModItems.FERMENTED_TEA_LEAVES);
        DRYING_RESULTS.put("teatime:withered", ModItems.DRIED_TEA_LEAVES);
    }

}
