/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.teatime.block.entity;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ml.pluto7073.teatime.block.entity.ModBlockEntityTypes;
import ml.pluto7073.teatime.gui.handlers.SteamerMenu;
import ml.pluto7073.teatime.recipe.ModRecipes;
import ml.pluto7073.teatime.recipe.SteamerRecipe;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3922;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@class_6328
public class SteamerBlockEntity
extends class_2624
implements class_1278,
class_1732,
class_1737 {
    public static final int INPUT_SLOT_INDEX = 0;
    public static final int WATER_SLOT_INDEX = 1;
    public static final int OUTPUT_SLOT_INDEX = 2;
    public static final int WATER_TIME_PROPERTY_INDEX = 0;
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] SIDE_SLOTS = new int[]{1};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 1};
    public static final int TOTAL_WATER_PROPERTY_INDEX = 1;
    public static final int STEAM_TIME_PROPERTY_INDEX = 2;
    public static final int TOTAL_STEAM_TIME_PROPERTY_INDEX = 3;
    public static final int IS_BOILING_PROPERTY_INDEX = 4;
    public static final int PROPERTY_COUNT = 5;
    public static final int DEFAULT_STEAM_TIME = 1200;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    public int waterTime;
    public int totalWater;
    public int steamTime;
    public int steamTimeTotal;
    public final class_3913 propertyDelegate;
    private final Object2IntOpenHashMap<class_2960> recipesUsed;
    private final class_1863.class_7266<class_1263, ? extends SteamerRecipe> matchGetter;

    public SteamerBlockEntity(final class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntityTypes.STEAMER_TYPE, blockPos, blockState);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                switch (index) {
                    case 0: {
                        return SteamerBlockEntity.this.waterTime;
                    }
                    case 1: {
                        return SteamerBlockEntity.this.totalWater;
                    }
                    case 2: {
                        return SteamerBlockEntity.this.steamTime;
                    }
                    case 3: {
                        return SteamerBlockEntity.this.steamTimeTotal;
                    }
                    case 4: {
                        return SteamerBlockEntity.this.isBoiling(blockPos, SteamerBlockEntity.this.field_11863) ? 1 : 0;
                    }
                }
                return 0;
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        SteamerBlockEntity.this.waterTime = value;
                        break;
                    }
                    case 1: {
                        SteamerBlockEntity.this.totalWater = value;
                        break;
                    }
                    case 2: {
                        SteamerBlockEntity.this.steamTime = value;
                        break;
                    }
                    case 3: {
                        SteamerBlockEntity.this.steamTimeTotal = value;
                        break;
                    }
                }
            }

            public int method_17389() {
                return 5;
            }
        };
        this.recipesUsed = new Object2IntOpenHashMap();
        this.matchGetter = class_1863.method_42302(ModRecipes.STEAMING);
    }

    public static Map<class_1792, Integer> createWaterTimeMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        SteamerBlockEntity.addWaterInput(map, (class_1935)class_1802.field_8705, 20000);
        SteamerBlockEntity.addWaterInput(map, (class_1935)class_1802.field_8574, 6666);
        return map;
    }

    private static void addWaterInput(Map<class_1792, Integer> waterSizes, class_1935 item, int waterSize) {
        waterSizes.put(item.method_8389(), waterSize);
    }

    public boolean isBoiling(class_2338 pos, class_1937 level) {
        class_2680 campfire = level.method_8320(pos.method_10074());
        if (!campfire.method_26164(class_3481.field_23799)) {
            return false;
        }
        if (!class_3922.method_23896((class_2680)campfire)) {
            return false;
        }
        return this.waterTime > 0;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.steamer");
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.waterTime = nbt.method_10568("WaterTime");
        this.steamTime = nbt.method_10568("SteamTime");
        this.steamTimeTotal = nbt.method_10568("SteamTimeTotal");
        this.totalWater = this.getWaterSize((class_1799)this.inventory.get(1));
        class_2487 recipes = nbt.method_10562("RecipesUsed");
        for (String key : recipes.method_10541()) {
            this.recipesUsed.put((Object)new class_2960(key), recipes.method_10550(key));
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10575("WaterTime", (short)this.waterTime);
        nbt.method_10575("SteamTime", (short)this.steamTime);
        nbt.method_10575("SteamTimeTotal", (short)this.steamTimeTotal);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        class_2487 recipes = new class_2487();
        this.recipesUsed.forEach((identifier, count) -> recipes.method_10569(identifier.toString(), count.intValue()));
        nbt.method_10566("RecipesUsed", (class_2520)recipes);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, SteamerBlockEntity blockEntity) {
        boolean hasWaterItem;
        boolean boiling = blockEntity.isBoiling(pos, level);
        boolean dirty = false;
        if (blockEntity.isBoiling(pos, level)) {
            --blockEntity.waterTime;
        }
        class_1799 waterStack = (class_1799)blockEntity.inventory.get(1);
        boolean hasInput = !((class_1799)blockEntity.inventory.get(0)).method_7960();
        boolean bl = hasWaterItem = !waterStack.method_7960();
        if (blockEntity.isBoiling(pos, level) || hasInput && hasWaterItem) {
            SteamerRecipe recipe = hasInput ? (SteamerRecipe)blockEntity.matchGetter.method_42303((class_1263)blockEntity, level).orElse(null) : null;
            int i = blockEntity.method_5444();
            if (!blockEntity.isBoiling(pos, level) && SteamerBlockEntity.canAcceptRecipeOutput(recipe, blockEntity.inventory, i)) {
                blockEntity.totalWater = blockEntity.waterTime = blockEntity.getWaterSize(waterStack);
                if (blockEntity.isBoiling(pos, level)) {
                    dirty = true;
                    if (hasWaterItem) {
                        class_1792 item = waterStack.method_7909();
                        waterStack.method_7934(1);
                        if (waterStack.method_7960()) {
                            class_1792 remainder = item.method_7858();
                            blockEntity.inventory.set(1, (Object)(remainder == null ? class_1799.field_8037 : new class_1799((class_1935)remainder)));
                        }
                    }
                }
            }
            if (blockEntity.isBoiling(pos, level) && SteamerBlockEntity.canAcceptRecipeOutput(recipe, blockEntity.inventory, i)) {
                ++blockEntity.steamTime;
                if (blockEntity.steamTime == blockEntity.steamTimeTotal) {
                    blockEntity.steamTime = 0;
                    blockEntity.steamTimeTotal = SteamerBlockEntity.getSteamTime(level, blockEntity);
                    if (SteamerBlockEntity.craftRecipe(recipe, blockEntity.inventory, i)) {
                        blockEntity.method_7662(recipe);
                    }
                    dirty = true;
                }
            } else {
                blockEntity.steamTime = 0;
            }
        } else if (!blockEntity.isBoiling(pos, level) && blockEntity.steamTime > 0) {
            blockEntity.steamTime = class_3532.method_15340((int)(blockEntity.steamTime - 2), (int)0, (int)blockEntity.steamTimeTotal);
        }
        if (boiling != blockEntity.isBoiling(pos, level)) {
            dirty = true;
        }
        if (dirty) {
            SteamerBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    private static boolean canAcceptRecipeOutput(@Nullable SteamerRecipe recipe, class_2371<class_1799> slots, int count) {
        if (!((class_1799)slots.get(0)).method_7960() && recipe != null) {
            class_1799 wantedOutput = recipe.output;
            if (wantedOutput.method_7960()) {
                return false;
            }
            class_1799 outputSlot = (class_1799)slots.get(2);
            if (outputSlot.method_7960()) {
                return true;
            }
            if (!outputSlot.method_7909().equals(wantedOutput.method_7909())) {
                return false;
            }
            if (outputSlot.method_7947() < count && outputSlot.method_7947() < outputSlot.method_7914()) {
                return true;
            }
            return outputSlot.method_7947() < wantedOutput.method_7914();
        }
        return false;
    }

    private static boolean craftRecipe(@Nullable SteamerRecipe recipe, class_2371<class_1799> slots, int count) {
        if (recipe != null && SteamerBlockEntity.canAcceptRecipeOutput(recipe, slots, count)) {
            class_1799 input = (class_1799)slots.get(0);
            class_1799 output = recipe.output.method_7972();
            class_1799 outputSlot = (class_1799)slots.get(2);
            if (outputSlot.method_7960()) {
                slots.set(2, (Object)output.method_7972());
            } else if (outputSlot.method_31574(output.method_7909())) {
                outputSlot.method_7933(1);
            }
            input.method_7934(1);
            return true;
        }
        return false;
    }

    protected int getWaterSize(class_1799 water) {
        if (water.method_7960()) {
            return 0;
        }
        class_1792 item = water.method_7909();
        return SteamerBlockEntity.createWaterTimeMap().getOrDefault(item, 0);
    }

    private static int getSteamTime(class_1937 level, SteamerBlockEntity blockEntity) {
        return blockEntity.matchGetter.method_42303((class_1263)blockEntity, level).map(SteamerRecipe::getSteamTime).orElse(1200);
    }

    public static boolean canUseAsWater(class_1799 item) {
        return SteamerBlockEntity.createWaterTimeMap().containsKey(item.method_7909());
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        return side == class_2350.field_11036 ? TOP_SLOTS : SIDE_SLOTS;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new SteamerMenu(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.isValid(slot, stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (dir == class_2350.field_11033 && slot == 1) {
            return stack.method_31574(class_1802.field_8550) || stack.method_31574(class_1802.field_8469);
        }
        return true;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 s = (class_1799)this.inventory.get(slot);
        boolean canInsert = !stack.method_7960() && stack.method_7909().equals(s.method_7909()) && class_1799.method_31577((class_1799)s, (class_1799)stack);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (slot == 0 && !canInsert) {
            this.steamTimeTotal = SteamerBlockEntity.getSteamTime(this.field_11863, this);
            this.steamTime = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public boolean isValid(int slot, class_1799 stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        return SteamerBlockEntity.canUseAsWater(stack);
    }

    public void method_7683(class_1662 contents) {
        for (class_1799 stack : this.inventory) {
            contents.method_7400(stack);
        }
    }

    public void method_7662(@Nullable class_1860<?> recipe) {
        if (recipe != null) {
            class_2960 identifier = recipe.method_8114();
            this.recipesUsed.addTo((Object)identifier, 1);
        }
    }

    @Nullable
    public class_1860<?> method_7663() {
        return null;
    }

    public void method_5448() {
        this.inventory.clear();
    }
}

