/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.teatime.teatypes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import ml.pluto7073.pdapi.util.DrinkUtil;
import ml.pluto7073.teatime.TeaTime;
import ml.pluto7073.teatime.networking.packets.clientbound.ClientboundSyncCustomTeaTypesPacket;
import ml.pluto7073.teatime.teatypes.TeaType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5321;

public class TeaTypeManager
implements SimpleSynchronousResourceReloadListener {
    public static final class_2960 PHASE = TeaTime.asId("phase/tea_types");
    public static final class_5321<class_2378<TeaType>> TEA_TYPE = class_5321.method_29180((class_2960)TeaTime.asId("tea_type"));
    public static final class_5321<TeaType> EMPTY = TeaTypeManager.baseType("empty");
    public static final class_5321<TeaType> HERBAL_TEA = TeaTypeManager.baseType("herbal_tea");
    public static final class_5321<TeaType> WHITE_TEA = TeaTypeManager.baseType("white_tea");
    public static final class_5321<TeaType> GREEN_TEA = TeaTypeManager.baseType("green_tea");
    public static final class_5321<TeaType> BLACK_TEA = TeaTypeManager.baseType("black_tea");
    private static final Map<class_2960, TeaType> REGISTRY = new HashMap<class_2960, TeaType>();
    public static final TeaType EMPTY_TYPE = new TeaType(Optional.empty(), 0, List.of(), 0, List.of(), true, "");

    public TeaTypeManager() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(PHASE, (player, joined) -> TeaTypeManager.send(player));
    }

    private static class_5321<TeaType> baseType(String id) {
        return class_5321.method_29179(TEA_TYPE, (class_2960)TeaTime.asId(id));
    }

    public static TeaType register(class_2960 id, TeaType teaType) {
        REGISTRY.put(id, teaType);
        return teaType;
    }

    public static TeaType getFromIngredients(List<class_1792> stacks) {
        block0: for (class_2960 i : REGISTRY.keySet()) {
            if (i.toString().equals("teatime:empty") || i.toString().equals("teatime:herbal_tea")) continue;
            TeaType type = REGISTRY.get(i);
            ArrayList<class_1792> wantedItems = new ArrayList<class_1792>(type.getIngredients());
            if (stacks.size() != wantedItems.size()) continue;
            for (class_1792 item : stacks) {
                if (wantedItems.remove(item)) continue;
                continue block0;
            }
            if (!wantedItems.isEmpty()) continue;
            return type;
        }
        return EMPTY_TYPE;
    }

    public static TeaType get(class_5321<TeaType> key) {
        return TeaTypeManager.get(key.method_29177());
    }

    public static TeaType get(class_2960 id) {
        if (!REGISTRY.containsKey(id)) {
            return EMPTY_TYPE;
        }
        return REGISTRY.get(id);
    }

    public static void send(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)new ClientboundSyncCustomTeaTypesPacket((Map<class_2960, TeaType>)ImmutableMap.copyOf(REGISTRY)));
    }

    public static boolean containsId(class_2960 id) {
        return REGISTRY.containsKey(id);
    }

    public static class_2960 getId(TeaType teaType) {
        for (class_2960 i : REGISTRY.keySet()) {
            TeaType type = REGISTRY.get(i);
            if (!type.equals(teaType)) continue;
            return i;
        }
        return new class_2960("empty");
    }

    public static Set<class_2960> getIds() {
        return REGISTRY.keySet();
    }

    public static List<class_2960> getOrderedIdListDisplayed() {
        Set<class_2960> allIds = TeaTypeManager.getIds();
        ArrayList<class_2960> herbalTeas = new ArrayList<class_2960>();
        ArrayList<class_2960> whiteTeas = new ArrayList<class_2960>();
        ArrayList<class_2960> greenTeas = new ArrayList<class_2960>();
        ArrayList<class_2960> blackTeas = new ArrayList<class_2960>();
        ArrayList<class_2960> miscTeas = new ArrayList<class_2960>();
        for (class_2960 id : allIds) {
            TeaType type = TeaTypeManager.get(id);
            if (type.internal()) continue;
            if (type.parent().isEmpty()) {
                miscTeas.add(id);
                continue;
            }
            if (type.parent().equals(Optional.of(HERBAL_TEA))) {
                herbalTeas.add(id);
                continue;
            }
            if (type.parent().equals(Optional.of(WHITE_TEA))) {
                whiteTeas.add(id);
                continue;
            }
            if (type.parent().equals(Optional.of(GREEN_TEA))) {
                greenTeas.add(id);
                continue;
            }
            if (type.parent().equals(Optional.of(BLACK_TEA))) {
                blackTeas.add(id);
                continue;
            }
            miscTeas.add(id);
        }
        Comparator comparator = DrinkUtil.alphabetizer(class_2960::toString);
        herbalTeas.sort(comparator);
        whiteTeas.sort(comparator);
        greenTeas.sort(comparator);
        blackTeas.sort(comparator);
        miscTeas.sort(comparator);
        whiteTeas.add(0, WHITE_TEA.method_29177());
        greenTeas.add(0, GREEN_TEA.method_29177());
        blackTeas.add(0, BLACK_TEA.method_29177());
        return Streams.concat((Stream[])new Stream[]{herbalTeas.stream(), whiteTeas.stream(), greenTeas.stream(), blackTeas.stream()}).toList();
    }

    public static List<TeaType> values() {
        return REGISTRY.values().stream().toList();
    }

    public static void init() {
    }

    public static void resetRegistry() {
        REGISTRY.clear();
    }

    public class_2960 getFabricId() {
        return TeaTime.asId("tea_type_registerer");
    }

    public void method_14491(class_3300 manager) {
        TeaTypeManager.resetRegistry();
        int i = 0;
        for (Map.Entry entry : manager.method_14488("tea_types", id -> id.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id2 = new class_2960(((class_2960)entry.getKey()).method_12836(), ((class_2960)entry.getKey()).method_12832().replace("tea_types/", "").replace(".json", ""));
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    boolean b;
                    JsonObject object = class_3518.method_15255((Reader)new InputStreamReader(stream));
                    if (object.has("fabric:load_conditions") && !(b = ResourceConditions.conditionsMatch((JsonArray)class_3518.method_15261((JsonObject)object, (String)"fabric:load_conditions"), (boolean)true))) continue;
                    TeaTypeManager.register(id2, (TeaType)TeaType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).getOrThrow(false, s -> {
                        throw new JsonSyntaxException(s);
                    }));
                    ++i;
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                TeaTime.logger.error("Could not load custom tea type {}", (Object)id2, (Object)e);
            }
        }
        TeaTime.logger.info("Loaded {} custom tea types", (Object)i);
    }
}

