/*
 * Decompiled with CFR 0.152.
 */
package ml.pluto7073.teatime.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import ml.pluto7073.pdapi.addition.DrinkAddition;
import ml.pluto7073.pdapi.util.DrinkUtil;
import ml.pluto7073.teatime.item.ModItems;
import ml.pluto7073.teatime.teatypes.TeaType;
import ml.pluto7073.teatime.teatypes.TeaTypeManager;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public final class TeaTimeUtils {
    public static final Map<String, class_1792> DRYING_RESULTS = new HashMap<String, class_1792>();
    public static final int MAX_TIME_DRYING = 200;
    public static final Codec<class_1293> MOB_EFFECT_CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)class_7923.field_41174.method_39673().fieldOf("effect").forGetter(class_1293::method_5579), (App)Codec.INT.fieldOf("duration").forGetter(class_1293::method_5584), (App)Codec.INT.fieldOf("amplifier").forGetter(class_1293::method_5578)).apply((Applicative)instance, class_1293::new));

    public static List<class_1799> getRolledLeaves() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (String s : DRYING_RESULTS.keySet()) {
            class_1799 stack = new class_1799((class_1935)ModItems.ROLLED_TEA_LEAVES);
            stack.method_7911("TeaData").method_10582("mod", s);
            stacks.add(stack);
        }
        return stacks;
    }

    public static List<class_1799> getTeaBags() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_1799 stack = new class_1799((class_1935)ModItems.TEA_BAG);
        for (class_2960 i : TeaTypeManager.getOrderedIdListDisplayed()) {
            if (i.equals((Object)new class_2960("teatime:empty"))) continue;
            stacks.add(TeaTimeUtils.setTeaType(stack.method_7972(), TeaTypeManager.get(i)));
        }
        return stacks;
    }

    public static List<class_1799> getTea() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_1799 tea = new class_1799((class_1935)ModItems.TEA, 1);
        for (class_2960 i : TeaTypeManager.getOrderedIdListDisplayed()) {
            if (i.equals((Object)new class_2960("teatime:empty"))) continue;
            stacks.add(TeaTimeUtils.setTeaType(tea.method_7972(), TeaTypeManager.get(i)));
        }
        return stacks;
    }

    public static class_1792 getDryingResult(class_1799 stack) {
        String mod = stack.method_7911("TeaData").method_10545("mod") ? stack.method_7911("TeaData").method_10558("mod") : "teatime:null";
        return DRYING_RESULTS.getOrDefault(mod, ModItems.ROLLED_TEA_LEAVES);
    }

    public static boolean hasDryingResult(class_1799 stack) {
        String mod = stack.method_7911("TeaData").method_10545("mod") ? stack.method_7911("TeaData").method_10558("mod") : "teatime:null";
        return DRYING_RESULTS.containsKey(mod);
    }

    public static String getRolledTooltip(class_1799 stack) {
        String mod = stack.method_7911("TeaData").method_10558("mod");
        class_1792 result = DRYING_RESULTS.get(mod);
        if (result == null) {
            return "";
        }
        return result.method_7876();
    }

    public static String getTeaTypeStr(class_1799 stack) {
        return stack.method_7911("TeaData").method_10545("type") ? stack.method_7911("TeaData").method_10558("type") : "teatime:empty";
    }

    public static TeaType getTeaType(class_1799 stack) {
        return TeaTimeUtils.getTeaType(stack.method_7911("TeaData"));
    }

    public static TeaType getTeaType(class_2487 teaData) {
        String type = teaData.method_10545("type") ? teaData.method_10558("type") : "teatime:empty";
        return TeaTypeManager.containsId(new class_2960(type)) ? TeaTypeManager.get(new class_2960(type)) : TeaTypeManager.EMPTY_TYPE;
    }

    public static class_2960 getTeaTypeId(class_1799 stack) {
        TeaType type = TeaTimeUtils.getTeaType(stack);
        return TeaTypeManager.getId(type);
    }

    public static class_1799 setTeaType(class_1799 stack, TeaType type) {
        return TeaTimeUtils.setTeaType(stack, TeaTypeManager.getId(type));
    }

    public static class_1799 setTeaType(class_1799 stack, class_2960 teaId) {
        stack.method_7911("TeaData").method_10582("type", teaId.toString());
        return stack;
    }

    public static class_1799 setTeaType(class_1799 stack, class_5321<TeaType> id) {
        return TeaTimeUtils.setTeaType(stack, id.method_29177());
    }

    public static <T> T create(Supplier<T> supplier) {
        return supplier.get();
    }

    public static int getTeaColor(class_1799 stack) {
        int colour = 0;
        if (TeaTimeUtils.getTeaType(stack) != null) {
            colour = TeaTimeUtils.getTeaType(stack).getColour();
        }
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        int colourCount = 1;
        for (DrinkAddition addition : DrinkUtil.getAdditionsFromStack((class_1799)stack)) {
            if (!addition.changesColor()) continue;
            int additionColour = addition.getColor();
            r += (float)(additionColour >> 16 & 0xFF) / 255.0f;
            g += (float)(additionColour >> 8 & 0xFF) / 255.0f;
            b += (float)(additionColour & 0xFF) / 255.0f;
            ++colourCount;
        }
        r = r / (float)colourCount * 255.0f;
        g = g / (float)colourCount * 255.0f;
        b = b / (float)colourCount * 255.0f;
        return (int)r << 16 | (int)g << 8 | (int)b;
    }

    static {
        DRYING_RESULTS.put("teatime:steamed", ModItems.FERMENTED_TEA_LEAVES);
        DRYING_RESULTS.put("teatime:withered", ModItems.DRIED_TEA_LEAVES);
    }
}

